/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.util.IOUtil;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.ProcessUtil;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContextContributor;
import com.aptana.scripting.model.EnvironmentContributor;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullnameEnvContextContributor
implements ContextContributor,
EnvironmentContributor {
    private static final String TM_FULLNAME = "TM_FULLNAME";
    private Map<String, Map<String, String>> fgCache = new HashMap<String, Map<String, String>>(3);

    @Override
    public void modifyContext(CommandElement command, CommandContext context) {
        context.put(String.valueOf(System.currentTimeMillis()) + "_env", this);
    }

    @Override
    public Map<String, String> toEnvironment() {
        Map<String, String> map;
        String username = System.getProperty("user.name");
        if (username == null) {
            username = "";
        }
        if ((map = this.fgCache.get(username)) != null) {
            return map;
        }
        map = new HashMap<String, String>();
        if (Platform.getOS().equals("macosx")) {
            String appleScript = "do shell script \"echo \" & the long user name of (system info)";
            String output = ProcessUtil.outputForCommand((String)"osascript", null, (String[])new String[]{"-e", appleScript});
            if (output != null) {
                String[] lines = output.split("\r|\n|\r\n");
                map.put(TM_FULLNAME, lines[lines.length - 1]);
            }
        } else if (Platform.getOS().equals("win32")) {
            String fullusername = System.getenv("USERNAME");
            if (fullusername != null && fullusername.trim().length() > 0) {
                map.put(TM_FULLNAME, fullusername);
            }
        } else if (username.trim().length() > 0) {
            try {
                Process p = this.createProcessRunner().run(new String[]{"/usr/bin/getent", "passwd", username});
                String read = IOUtil.read((InputStream)p.getInputStream(), (String)"UTF-8");
                String raw = read.split(":")[4];
                String fullname = raw.split(",")[0];
                map.put(TM_FULLNAME, fullname);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.fgCache.put(username, map);
        return map;
    }

    protected IProcessRunner createProcessRunner() {
        return new ProcessRunner();
    }
}

